terraform {
  required_providers {
    huaweicloud = {
      source = "huaweicloud/huaweicloud"
      version = ">= 1.54.1"
    }
  }
}

# Configure the HUAWEI CLOUD provider.
provider "huaweicloud" {
  auth_url = "https://iam.ru-moscow-1.hc.sbercloud.ru/v3" # Authorization address
  region   = "ru-moscow-1" # The region where the cloud infrastructure will be deployed

  endpoints = {
    vpc = "https://vpc.ru-moscow-1.hc.sbercloud.ru",
    iam = "https://iam.ru-moscow-1.hc.sbercloud.ru",
    ecs = "https://ecs.ru-moscow-1.hc.sbercloud.ru",
    ims = "https://ims.ru-moscow-1.hc.sbercloud.ru",
    nat = "https://nat.ru-moscow-1.hc.sbercloud.ru",
    evs = "https://evs.ru-moscow-1.hc.sbercloud.ru",
    obs = "https://obs.ru-moscow-1.hc.sbercloud.ru"
  }
 

  # Authorization keys
  access_key = var.access_key
  secret_key = var.secret_key
}