# Создание ролей  для CSPM по нашей инструкции https://www.cloudadvisor.app/docs/ru/connect/sbercloudadvanced.html
# https://registry.terraform.io/providers/huaweicloud/huaweicloud/latest/docs/resources/identity_role

resource "huaweicloud_identity_role" "ca-read-only-global-services-policy" {
  name        = "ca-read-only-global-services-policy-${random_string.ca-suffix.id}"
  description = "Read-only policy for Cloud Advisor access to services available in all regions, like IAM and OBS"
  type        = "AX"
  policy      = <<EOF
{
  "Version": "1.1",
  "Statement": [
    {
      "Action": [
        "iam:*:list*",
        "iam:*:get*",
        "obs:bucket:list*",
        "obs:bucket:get*"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

resource "huaweicloud_identity_role" "ca-read-only-project-level-policy" {
  name        = "ca-read-only-project-level-policy-${random_string.ca-suffix.id}"
  description = "Read-only policy for Cloud Advisor access to services deployed in a specific region, like ECS, EVS, and others"
  type        = "XA"
  policy      = <<EOF
{
  "Version": "1.1",
  "Statement": [
    {
      "Action": [
        "*:*:list",
        "ecs:*:get",
        "elb:*:get",
        "FunctionGraph:function:getConfig",
        "vpc:*:get",
        "waf:*:get"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

# Создаем пользователя
# https://registry.terraform.io/providers/huaweicloud/huaweicloud/latest/docs/resources/identity_user

resource "huaweicloud_identity_user" "ca-user" {
  name        = "cloudadvisor-${random_string.ca-suffix.id}"
  description = "User account used for the Cloud Advisor service operation"
  access_type =  "programmatic"
  pwd_reset   = false
  enabled     = true
}

# Создаем группу пользователей
# https://registry.terraform.io/providers/huaweicloud/huaweicloud/latest/docs/resources/identity_group

resource "huaweicloud_identity_group" "ca-user-group" {
  name        = "CloudAdvisor-${random_string.ca-suffix.id}"
  description = "Group for the cloudadvisor user account used for the Cloud Advisor"
}

# Связываем пользователя с группой
# https://registry.terraform.io/providers/huaweicloud/huaweicloud/latest/docs/resources/identity_group_membership

resource "huaweicloud_identity_group_membership" "ca-membership" {
  group = huaweicloud_identity_group.ca-user-group.id
  users = [
    huaweicloud_identity_user.ca-user.id
  ]
}


# Связываем группу пользователей с ролью и всеми проектами
# https://registry.terraform.io/providers/huaweicloud/huaweicloud/latest/docs/resources/identity_group_membership

resource "huaweicloud_identity_group_role_assignment" "ca-role-assignment-1" {
  group_id   = huaweicloud_identity_group.ca-user-group.id
  role_id    = huaweicloud_identity_role.ca-read-only-project-level-policy.id
  project_id = "all"
}

# Асигнуем роли группе пользователей
# https://registry.terraform.io/providers/huaweicloud/huaweicloud/latest/docs/resources/identity_role_assignment

resource "huaweicloud_identity_role_assignment" "ca-role-assignment-2" {
  role_id   = huaweicloud_identity_role.ca-read-only-global-services-policy.id
  group_id  = huaweicloud_identity_group.ca-user-group.id
  domain_id = var.domain_id
}


# Добавляем MOS проект для кастомных политик
# Иначе могут наблюдаться баги с s3

data "huaweicloud_identity_projects" "mos_project" {
  name = "MOS" 
}

resource "huaweicloud_identity_role_assignment" "ca-role-assignment-3" {
  role_id   = huaweicloud_identity_role.ca-read-only-global-services-policy.id
  group_id  = huaweicloud_identity_group.ca-user-group.id
  project_id = data.huaweicloud_identity_projects.mos_project.projects[0].id
}



// Генерируем случайную последовательность для суффикса названия бакета
// https://registry.terraform.io/providers/hashicorp/random/latest/docs/resources/string

resource "random_string" "ca-suffix" {
	length		= 5
	upper		= false
	lower		= false
	numeric		= true
	special		= false
}

# Создаем AK/SK для нашего пользователя
# TODO Думать что делать с файлом credentials.csv. Сейчас нельзя в terraform output -json получить секрет
# Видимо надо как-то читать его в переменную а потом вывести в output
# https://registry.terraform.io/providers/huaweicloud/huaweicloud/latest/docs/resources/identity_access_key

resource "huaweicloud_identity_access_key" "ca-key" {
  user_id = huaweicloud_identity_user.ca-user.id
  secret_file =  "./credentials.csv"
}
